'use strict';

angular.module('genisis').controller('loginCtrl', ['$scope', '$rootScope',
  'user', '$location',
  function ($scope, $rootScope, $user, $location) {

    //if they are logged in push them into the requests
    if ($user.loggedIn()) {
      $location.path('/requests');
      $location.replace();
    }

    /**
     * Try to login to the website
     * @param object angular form validation
     * @return boolean
     **/
    $scope.login = function (formValidation) {

      //clear any existing errors
      $rootScope.errors = [];

      if (formValidation.email.$invalid) {
        $rootScope.errors.push('You must enter a valid email.');
      }

      // if (formValidation.password.$invalid) {
      //   $rootScope.errors.push('You must enter a valid password.');
      // }

      //prevent trying to login if there was a form error
      if ($rootScope.errors.length) {
        return false;
      }

      return $user.login($scope.email);
    };
  }
]);